<?php get_header(); // add header ?>  
<?php
    // Header AD 728
    $multicote_wp_header_728 = get_theme_mod('multicote_wp_header_728'); 
    // Display AD (Yes/No)
    $multicote_wp_display_ad = get_theme_mod('multicote_wp_display_ad');
    if (empty($multicote_wp_display_ad)) { $multicote_wp_display_ad = 'No'; }

    // Display Small author box
    $multicote_wp_display_smallab = get_theme_mod('multicote_wp_display_smallab');
    if (empty($multicote_wp_display_smallab)) { $multicote_wp_display_smallab = 'No'; } 

    // Display First Content Letter
    $multicote_wp_display_letter = get_theme_mod('multicote_wp_display_letter');
    if (empty($multicote_wp_display_letter)) { $multicote_wp_display_letter = 'No'; }        
?>

<!-- Begin Content -->
<div class="wrap-fullwidth">
    <div class="single-content">

        <?php if ($multicote_wp_display_ad == 'Yes') { ?>
        <div class="single-box">
            <div class="single-money">
                <?php echo stripslashes($multicote_wp_header_728); ?> 
            </div>
        </div><div class="clear"></div>
        <?php } ?>
        <ul class="single-breadcrumbs">
            <li><a href="<?php echo esc_url(home_url( '/' )); ?>"><?php esc_html_e('Home', 'multicote-wp'); ?></a> <i class="fas fa-angle-right"></i></li>
            <li><?php $multicote_wp_category = get_the_category(); if ($multicote_wp_category) { echo '<a href="' . get_category_link( $multicote_wp_category[0]->term_id ) . '" class="tiptipBlog" title="' . sprintf( esc_html__( "View all posts in %s", "multicote-wp" ), $multicote_wp_category[0]->name ) . '" ' . '>' . $multicote_wp_category[0]->name.'</a> ';}  ?> <i class="fas fa-angle-right"></i></li>
            <li><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></li>
        </ul>
        <div class="clear"></div>
        <!-- end .single-box -->



        <?php if (have_posts()) : while (have_posts()) : the_post();  ?>
        <div class="entry-top">
            <h1 class="article-title entry-title"><?php the_title(); ?></h1> 
            <span><?php esc_html_e('Written by', 'multicote-wp'); ?> <?php the_author_posts_link(); ?></span> <i class="fas fa-check-circle"></i>
        </div><div class="clear"></div>
        <?php endwhile; endif; ?>


        <article>
            <?php if (have_posts()) : while (have_posts()) : the_post();  ?>
            <?php if (function_exists('setPostViews_multicote_wp')) { ?><?php setPostViews_multicote_wp(get_the_ID()); } ?>
            <div <?php post_class('post') ?> id="post-<?php the_ID(); ?>">

            <div class="media-single-content">
            <?php if ( function_exists( 'rwmb_meta' ) ) {  
            // If Meta Box plugin is activate ?>
                <?php
                $multicote_wp_youtubecode = rwmb_meta('multicote_wp_youtube', true );
                $multicote_wp_vimeocode = rwmb_meta('multicote_wp_vimeo', true );
                $multicote_wp_image = rwmb_meta('multicote_wp_slider', true );
                $multicote_wp_hideimg = rwmb_meta('multicote_wp_hideimg', true );
                ?> 

                <?php if(!empty($multicote_wp_image)) { ?>
                    <!-- #### Single Gallery #### -->
                    <div class="single-gallery">
                        <?php
                        $images = rwmb_meta( 'multicote_wp_slider', 'type=image&size=multicote-wp-thumbnail-blog-small' );
                        foreach($images as $key =>$multicote_wp_image)
                         { echo wp_kses_post("<a href='{$multicote_wp_image['full_url']}' data-fslightbox='gallery1'><img src='{$multicote_wp_image['url']}'  alt='{$multicote_wp_image['alt']}'  /></a>");
                        } ?>
                    </div><!-- end .single-gallery --> 
                <?php } ?>

                <?php if(!empty($multicote_wp_youtubecode)) { ?>
                    <!-- #### Youtube video #### -->
                    <?php $multicote_wp_youtubeembed = '//www.youtube.com/embed/'; ?>
                    <iframe class="single_iframe" width="948" height="500" src="<?php echo esc_url($multicote_wp_youtubeembed); ?><?php echo esc_html($multicote_wp_youtubecode); ?>?wmode=transparent" frameborder="0" allowfullscreen></iframe>
                <?php } ?>

                <?php if(!empty($multicote_wp_vimeocode)) { ?>
                    <!-- #### Vimeo video #### -->
                    <?php $multicote_wp_vimeoembed = '//player.vimeo.com/video/'; ?>
                    <iframe class="single_iframe" width="948" height="500" src="<?php echo esc_url($multicote_wp_vimeoembed); ?><?php echo esc_html($multicote_wp_vimeocode); ?>?portrait=0" frameborder="0" allowFullScreen></iframe>
                <?php } ?>

                <?php if(!empty($multicote_wp_image) || !empty($multicote_wp_youtubecode) || !empty($multicote_wp_vimeocode)) { ?>
                <?php } elseif ( has_post_thumbnail()) { ?>
                    <?php if(!empty($multicote_wp_hideimg)) { } else { ?>
                     <?php the_post_thumbnail('multicote-wp-thumbnail-single-image'); ?>
                    <?php } // disable featured image ?>
                <?php } ?>

            <?php } else { 
            // Meta Box Plugin ?>
                <?php the_post_thumbnail('multicote-wp-thumbnail-single-image'); ?>
            <?php } ?> 
            </div><!-- end .media-single-content -->

                    <div class="entry">
                        <!-- entry content -->
                        <?php if ($multicote_wp_display_smallab == 'Yes') { ?>
                            <div class="author-right-meta">
                                <div class="aut-img">
                                    <a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php echo get_avatar( get_the_author_meta( 'user_email' ), 60 ); ?></a>
                                </div>
                                <ul class="aut-meta">
                                    <li class="name"><div class="vcard author"><span class="fn"><?php $multicote_wp_fname = get_the_author_meta('first_name'); if( empty($multicote_wp_fname)){ echo the_author_posts_link(); } else { echo the_author_meta('first_name'); echo ('&nbsp;'); echo substr(get_the_author_meta('last_name'),0,1).'.';} ?></span></div></li>
                                    <li class="time updated"><?php if ( function_exists( 'multicote_wp_time_ago' ) ) { echo multicote_wp_time_ago(); esc_html_e('ago', 'multicote-wp'); } else { the_time('M j, Y'); } ?></li>
                                    <li class="like sleft"><?php if (function_exists('thumbs_rating_getlink')) { echo thumbs_rating_getlink(); } ?></li>
                                    <div class="clear"></div>
                                </ul>    
                            </div><!-- end .author-right-media -->
                        <?php } ?>
                        <?php if ($multicote_wp_display_letter == 'No') { ?>
                            <?php the_content(''); // content ?>
                        <?php } else { ?>                        
                        <div class="p-first-letter">
                            <?php the_content(''); // content ?>
                        </div><!-- end .p-first-letter -->
                        <?php } ?>
                        <?php wp_link_pages(); // content pagination ?>
                        <div class="clear"></div>

                        <!-- tags -->
                        <?php $multicote_wp_single_tags = get_the_tags(); 
                        if ($multicote_wp_single_tags): ?>
                            <div class="ct-size"><div class="entry-btn"><?php esc_html_e( 'Article Tags:', 'multicote-wp' ); ?></div> <?php the_tags('',' &middot; '); // tags ?></div><div class="clear"></div>
                        <?php endif; ?>

                        <!-- categories -->
                        <?php $multicote_wp_single_categories = get_the_category(); 
                        if ($multicote_wp_single_categories): ?>
                            <div class="ct-size"><div class="entry-btn"><?php esc_html_e( 'Article Categories:', 'multicote-wp' ); ?></div> <?php the_category(' &middot; '); // categories ?></div><div class="clear"></div>
                        <?php endif; ?>

                        <div class="clear"></div>                        
                    </div><!-- end .entry -->
                    <div class="clear"></div> 
            </div><!-- end #post -->
            <?php endwhile; endif; ?>
        </article><!-- end article -->



        <!-- Related Articles -->
        <div class="single-related">
          <!-- Begin related articles on slide -->
          <div class="related-articles">

            <div class="related-title">
                <h3><?php esc_html_e('Related Articles', 'multicote-wp'); ?></h3>
                <div class="slide-nav">
                  <span id="slider-prev3"></span>
                  <span id="slider-next3"></span>
                </div><!-- end .slide-nav -->          
            </div><!-- end .related-title -->
            
            <ul class="related-articles-slider">
            <?php $multicote_wp_related = get_posts( array( 'category__in' => wp_get_post_categories($post->ID), 'ignore_sticky_posts' => 1, 'numberposts' => esc_attr(6), 'post__not_in' => array($post->ID) ) );
            if( $multicote_wp_related ) foreach( $multicote_wp_related as $post ) { setup_postdata($post); ?>    

                <li <?php post_class('post-slide') ?> id="post-<?php the_ID(); ?>">
                        <div class="article-category"><i></i> <?php $multicote_wp_category = get_the_category(); if ($multicote_wp_category) 
                            { echo '<a href="' . get_category_link( $multicote_wp_category[0]->term_id ) . '" class="tiptipBlog" title="' . sprintf( esc_html__( "View all posts in %s", "multicote-wp" ), $multicote_wp_category[0]->name ) . '" ' . '>' . $multicote_wp_category[0]->name.'</a> ';}  ?>
                        </div><!-- end .article-category -->                
                    <?php if ( has_post_thumbnail()) { ?>
                        <?php the_post_thumbnail('multicote-wp-thumbnail-blog-featured', array('title' => "")); ?>
                    <?php } else { ?> 
                        <a href="<?php the_permalink(); ?>"><img src="<?php echo get_template_directory_uri(); ?>/images/no-img.png" alt="<?php esc_html_e('article image', 'multicote-wp'); ?>" /></a> 
                    <?php } // Post Thumbnail ?> 


                    <div class="title-box">
                        <span><?php the_author_posts_link(); ?></span>
                        <?php if(function_exists('taqyeem_get_score')) { ?> <?php taqyeem_get_score(); ?> <?php } ?>                    
                        <div class="clear"></div>
                        <h2><a href="<?php the_permalink(); ?>"><?php if ( strlen(get_the_title()) > 60 ) { echo mb_substr(get_the_title(), 0, 56)." ..."; } else { the_title(''); } ?></a></h2>
                    </div>

                </li><!-- end .post-slide --> 
              <?php } wp_reset_postdata();  ?>  
            </ul><!-- end .related-articles-slider --> 
            
          </div> <div class="clear"></div> <!-- end .related-articles -->
        </div><!-- end .single.related -->



        <!-- Prev and Next articles -->
        <div class="prev-articles">
            <ul class="article_list">
            <?php
            $multicote_wp_previousPost = get_previous_post(true);
            if ($multicote_wp_previousPost) {
                $args = array(
                    'posts_per_page' => 1,
                    'include' => $multicote_wp_previousPost->ID
                );
            $multicote_wp_previousPost = get_posts($args);
            foreach ($multicote_wp_previousPost as $post) {
                setup_postdata($post);
            ?>
              <li>
                  <a href="<?php the_permalink(); ?>"> <?php echo the_post_thumbnail('multicote-wp-thumbnail-widget-small'); ?> </a>
                  <div class="an-widget-title" <?php if ( has_post_thumbnail()) { ?> style="margin-left:70px;" <?php } ?>>
                    <h4 class="article-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
                      <?php if(function_exists('taqyeem_get_score')) { ?>
                        <?php taqyeem_get_score(); ?>
                      <?php } ?>                    
                    <span><?php esc_html_e('by', 'multicote-wp'); ?> <?php the_author_posts_link(); ?></span> <i class="fas fa-check-circle"></i>
                  </div>
              </li>

            <?php wp_reset_postdata();
            } //end foreach
            } else { 
            $multicote_wp_nextPost = get_next_post(true);
            if ($multicote_wp_nextPost) {
                $args = array(
                    'posts_per_page' => 1,
                    'include' => $multicote_wp_nextPost->ID
                );
            $multicote_wp_nextPost = get_posts($args);
            foreach ($multicote_wp_nextPost as $post) {
                setup_postdata($post);
            ?>
              <li>
                  <a href="<?php the_permalink(); ?>"> <?php echo the_post_thumbnail('multicote-wp-thumbnail-widget-small'); ?> </a>
                  <div class="an-widget-title" <?php if ( has_post_thumbnail()) { ?> style="margin-left:70px;" <?php } ?>>
                    <h4 class="article-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
                      <?php if(function_exists('taqyeem_get_score')) { ?>
                        <?php taqyeem_get_score(); ?>
                      <?php } ?>                    
                    <span><?php esc_html_e('by', 'multicote-wp'); ?> <?php the_author_posts_link(); ?></span> <i class="fas fa-check-circle"></i>
                  </div>
              </li>
            <?php
                    wp_reset_postdata();
                    } //end foreach
                } // end if
            } // else
            ?>
            </ul><!-- end .article_list -->
        </div><div class="clear"></div>
        <!-- end .prev-articles --> 

 
        <!-- Comments -->
        <div class="entry-bottom">
            <?php if ( ! post_password_required() ) { ?>
                <?php if (get_comments_number()==0) { } else { ?>
                    <h3 class="title"><i></i> <?php esc_html_e( 'Comments', 'multicote-wp' ); ?></h3>
                <?php } ?>            
            <?php } ?>    
            
            <!-- Comments -->
            <div id="comments" class="comments">
                <?php comments_template('', true); // comments ?>
            </div>
            <div class="clear"></div>
        </div><!-- end .entry-bottom -->

    </div><!-- end .single-content -->


    <!-- Begin Sidebar (right) -->
    <?php  get_sidebar(); // add sidebar ?>
    <!-- end #sidebar  (right) -->    


    <div class="clear"></div>
</div><!-- end .wrap-fullwidth  -->

<?php get_footer(); // add footer  ?>